
#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.DAL.UnitTests
{

	
	

	[TestFixture]
	public class DAL_EnhancementMedia : BaseTest 
	{

		private DataTable _dtEnhancementMedia;
		

		[SetUp]
		protected void SetUp() 
		{				
			this.BaseSetUp();

			if (this.RefreshData)
			{
				this._dtEnhancementMedia = UnitTestUtil.RunSQLGetDataTable("SELECT * FROM EnhancementMedia", true);

				this.RefreshData = false;
			}

		}


		[Test]
		public void GetEnhancementMediaList_Pass()
		{	
			DataTable dtTest = DAL.EnhancementMedia.GetEnhancementMediaList();

			Assert.AreEqual(this._dtEnhancementMedia.Rows.Count, dtTest.Rows.Count, "Rows.Count");
			Assert.AreEqual(3, dtTest.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.EnhancementMedia.EnhancementMediaId), TABLES.EnhancementMedia.EnhancementMediaId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.EnhancementMedia.EnhancementMediaName), TABLES.EnhancementMedia.EnhancementMediaName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.EnhancementMedia.ReagentTypeId), TABLES.EnhancementMedia.ReagentTypeId);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetEnhancementMediaList_Fail()
		{	
		}
	}
}
#endif
